<?php

namespace IQDEV\ElasticSearch\Filter;

use Ramsey\Collection\AbstractCollection;

/**
 * @method self add(FilterGroupCollection $item)
 */
class FilterCollection extends AbstractCollection
{
    /** @var LogicOperator Тип логической операции для коллекции */
    protected LogicOperator $type;

    /**
     * @param FilterGroupCollection[] $data
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->type = new LogicOperator(LogicOperator::AND);
    }

    /**
     * @inheritDoc
     */
    public function getType(): string
    {
        return FilterGroupCollection::class;
    }

    /**
     * Установка типа логической операции
     *
     * @param LogicOperator $type
     *
     * @return $this
     */
    public function setLogicalType(LogicOperator $type): self
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Получение типа логической операции
     *
     * @return LogicOperator
     */
    public function getLogicalType(): LogicOperator
    {
        return $this->type;
    }
}
