<?php

namespace IQDEV\ElasticSearch\Facet;

final class FacetNumber implements Facetable
{
    private string $key;
    private float $value;

    public function __construct(string $key, float $value)
    {
        $this->key = $key;
        $this->value = $value;
    }

    public function es(): array
    {
        return [
            'facet_code' => $this->key,
            'facet_value' => $this->value,
        ];
    }
}
