<?php

namespace IQDEV\ElasticSearch\Order;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Document\Property\Type;

class Order implements Esable
{
    public Type $by;
    public OrderType $direction;
    public array $properties;

    public function __construct(Type $by, OrderType $direction, array $properties = [])
    {
        $this->by = $by;
        $this->direction = $direction;
        $this->properties = $properties;
    }

    public function es(): array
    {
        return array_merge([$this->by->key() => $this->direction::getType()], $this->properties);
    }

    public function orderBy(): Type
    {
        return $this->by;
    }

    public function orderType(): OrderType
    {
        return $this->direction;
    }

    public function orderProperties(): array
    {
        return $this->properties;
    }
}
