<?php

namespace IQDEV\ElasticSearch\Document\Property;

class PropertyType implements Type
{
    protected string $key;
    protected string $type;

    public const TYPE_NUMBER = 'number';
    public const TYPE_KEYWORD = 'keyword';

    public function __construct(string $key, string $type = null)
    {
        if (!in_array($type, self::types(), true)) {
            throw new \InvalidArgumentException(sprintf('Invalid type "%s" for property "%s"', $type, $key));
        }

        $this->key = $key;
        $this->type = $type;
    }

    public function key(): string
    {
        return $this->key;
    }

    public function type(): string
    {
        return $this->type;
    }

    public static function types(): array
    {
        return [
            self::TYPE_NUMBER,
            self::TYPE_KEYWORD,
        ];
    }
}
