<?php

namespace IQDEV\ElasticSearch\Facet;

final class FacetKeyword implements Facetable
{
    private string $key;
    /** @var string|array<string> */
    private string|array $value;

    /**
     * @param string|string[] $value
     */
    public function __construct(string $key, string|array $value)
    {
        $this->key = $key;
        $this->value = $value;
    }

    public function es(): array
    {
        return [
            'facet_code' => $this->key,
            'facet_value' => $this->value,
        ];
    }
}
