<?php

namespace IQDEV\ElasticSearch\Facet;

use IQDEV\ElasticSearch\Facet\Item\FacetItemCollection;
use IQDEV\ElasticSearch\Facet\Type\FacetType;

class Facet implements Facetable
{
    public FacetItemCollection $products;

    protected FacetType $type;

    protected string $code;

    public function __construct(FacetType $type, string $code)
    {
        $this->type = $type;
        $this->code = $code;
        $this->products = new FacetItemCollection();
    }

    public function getType(): FacetType
    {
        return $this->type;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function es(): array
    {
        return [
            'facet_code' => $this->code,
            'facet_value' => $this->type,
        ];
    }
}
