<?php

namespace IQDEV\ElasticSearchTests\Service;

use IQDEV\ElasticSearch\Config\BaseConfiguration as Configuration;
use IQDEV\ElasticSearch\Config\Mapping\ProductMapping;
use IQDEV\ElasticSearch\Request\Query\SearchQueryHandler;
use IQDEV\ElasticSearch\SearchService;
use IQDEV\ElasticSearchTests\Factory\ClientFactory;

class SearchClient
{
    private function __construct() { }

    protected static SearchQueryHandler $oInstance;

    public static function getInstance(): SearchQueryHandler
    {
        if (!isset(static::$oInstance)) {
            static::$oInstance = new SearchQueryHandler(
                new SearchService(
                    ClientFactory::create(),
                    new Configuration(new ProductMapping()),
                )
            );
        }
        
        return static::$oInstance;
    }
}