<?php

namespace IQDEV\ElasticSearch\Search;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Request\Match\QueryMatchCollection;
use IQDEV\ElasticSearch\Request\Order\OrderCollection;
use IQDEV\ElasticSearch\Search\Aggs\AggsCollection;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;

final class Request implements Esable
{
    private ?Query $query = null;
    private ?Query $postFilter = null;
    private ?AggsCollection $aggs = null;
    private ?Pagination $pagination = null;
    private ?OrderCollection $sort = null;
    private ?QueryMatchCollection $matchCollection = null;
    private ?array $source = null;

    public function setPagination(?Pagination $pagination): self
    {
        $this->pagination = $pagination;

        return $this;
    }

    public function getQuery(): Query
    {
        if (null === $this->query) {
            $this->query = new Query();
        }

        return $this->query;
    }

    public function setQuery(Query $query): self
    {
        $this->query = $query;

        return $this;
    }

    public function getPostFilter(): Query
    {
        if (null === $this->postFilter) {
            $this->postFilter = new Query();
        }

        return $this->postFilter;
    }

    public function setPostFilter(Query $query): self
    {
        $this->postFilter = $query;

        return $this;
    }

    public function getAggs(): AggsCollection
    {
        if (null === $this->aggs) {
            $this->aggs = new AggsCollection();
        }

        return $this->aggs;
    }

    public function setAggs(AggsCollection $aggs): self
    {
        $this->aggs = $aggs;

        return $this;
    }

    public function getQueryMatch(): QueryMatchCollection
    {
        if (null === $this->matchCollection) {
            $this->matchCollection = new QueryMatchCollection();
        }

        return $this->matchCollection;
    }

    public function getPagination(): ?Pagination
    {
        return $this->pagination;
    }

    public function setSource(array $s): self
    {
        $this->source = $s;

        return $this;
    }

    public function getSort(): OrderCollection
    {
        if (null === $this->sort) {
            $this->sort = new OrderCollection();
        }

        return $this->sort;
    }

    public function es(): array
    {
        $request = [];

        if ($this->source) {
            $request['_source'] = $this->source;
        }

        if ($this->postFilter && false === $this->postFilter->isEmpty()) {
            $request['post_filter'] = $this->postFilter->es()['query'];
        }

        if ($this->query && false === $this->query->isEmpty()) {
            $request['query'] = $this->query->es()['query'];
        }

        if ($this->matchCollection && false === $this->matchCollection->isEmpty()) {
            $request['query']['match'] = $this->matchCollection->es();
        }

        if ($this->aggs) {
            $request['aggs'] = $this->aggs->es()['aggs'];
        }

        if ($this->pagination) {
            $request = array_merge($request, $this->pagination->es());
        }

        if ($this->sort) {
            $request['sort'] = $this->sort->es();
        }

        return $request;
    }
}
