<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Request\Search;

use IQDEV\ElasticSearch\Config\MappingValidator;
use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Request\Match\QueryMatch;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;
use IQDEV\ElasticSearch\Search\BoolQuery\Terms;
use IQDEV\ElasticSearch\Search\Nested;

class SearchQuery
{
    public function __construct(
        private readonly Search $search,
    ) {
    }

    public function toQueryMatch(): QueryMatch
    {
        return new QueryMatch(
            $this->search->getProperty()->getKey(),
            $this->search->getValue(),
        );
    }

    public function toMust(Configuration $configuration): Terms|Nested
    {
        if (MappingValidator::isPropertyExists($configuration, $this->search->getProperty()->getKey())) {

            return new Terms($this->search->getProperty()->getKey(), $this->search->getValue());
        } else {
            $path = 'search_data.keyword_facet';

            $nested = new Nested();

            $query = new Query();
            $query->getFilter()->add(new Terms($path . '.facet_code', $this->search->getProperty()->getKey()));
            $query->getFilter()->add(new Terms($path . '.facet_value', $this->search->getValue()));

            $nested
                ->setPath($path)
                ->setQuery($query);

            return $nested;
        }
    }
}
