<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch;

abstract class Mapping implements Esable
{
    abstract public function getPropertiesMap(): array;
    public function getSearchDataMap(): array
    {
        return [
            'type' => 'nested',
            'properties' => [
                'keyword_facet' => [
                    'type' => 'nested',
                    'properties' => [
                        'facet_code' => [
                            'type' => 'keyword',
                            'index' => true
                        ],
                        'facet_value' => [
                            'type' => 'keyword',
                            'index' => true
                        ]
                    ]
                ],
                'number_facet' => [
                    'type' => 'nested',
                    'properties' => [
                        'facet_code' => [
                            'type' => 'keyword',
                            'index' => true
                        ],
                        'facet_value' => [
                            'type' => 'double'
                        ]
                    ]
                ]
            ]
        ];
    }

    public function es(): array
    {
        return [
            'properties' => array_merge(
                $this->getPropertiesMap(),
                ['search_data' => $this->getSearchDataMap()],
            )
        ];
    }
}
