<?php

namespace IQDEV\ElasticSearch\Config;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Mapping;

class BaseConfiguration implements Configuration
{
    public function __construct(
        private readonly Mapping $mapping,
    ) {
    }

    public function getIndexName(): string
    {
        return $_ENV['IQ_ES_PRODUCT_SEARCH_INDEX'];
    }

    public function getMapping(): Mapping
    {
        return $this->mapping;
    }

    public function getSettings(): array
    {
        return include __DIR__.'/product.settings.php';
    }
}
