<?php

namespace IQDEV\ElasticSearchTests\FIlter;

use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;
use IQDEV\Search\SearchQuery\SearchQuery;
use PHPUnit\Framework\TestCase;

class SortTest extends TestCase
{
    /**
     * Сортировка элементов по категории
     *
     * @return void
     */
    public function testSortByCategory(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'category_id',
                    'direction' => 'asc',
                    'type' => 'field'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'p1',
                's1',
                's2',
                's3',
                's4',
                'h1',
                'h2',
                'h3',
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Обратная сортировка элементов по категории
     *
     * @return void
     */
    public function testSortByCategoryReverse(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'category_id',
                    'direction' => 'desc',
                    'type' => 'field'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1',
                'h2',
                'h3',
                's1',
                's2',
                's3',
                's4',
                'p1',
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Сортировка элементов по свойству
     *
     * @return void
     */
    public function testSortByKeyword(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'color',
                    'direction' => 'asc',
                    'type' => 'property_keywords'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's3',
                's1',
                's4',
                's2',
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }
    
    /**
     * Сортировка элементов по свойству
     *
     * @return void
     */
    public function testSortByKeywordReverse(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'color',
                    'direction' => 'desc',
                    'type' => 'property_keywords'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h2',
                'h3',
                'p1',
                's2',
                'h1',
                's1',
                's4',
                's3',
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Сортировка элементов по свойству
     *
     * @return void
     */
    public function testSortByNumber(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'price',
                    'direction' => 'asc',
                    'type' => 'property_number'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's1',
                's2',
                's3',
                's4',
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Сортировка элементов по свойству
     *
     * @return void
     */
    public function testSortByNumberReverse(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'price',
                    'direction' => 'desc',
                    'type' => 'property_number'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'p1',
                'h3',
                'h2',
                'h1',
                's4',
                's3',
                's2',
                's1',
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Сортировка элементов по свойству
     *
     * @return void
     */
    public function testSortByCombined(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'size',
                    'direction' => 'asc',
                    'type' => 'property_keywords'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's4',
                's1',
                's2',
                's3',
                'h1',
                'h3',
                'p1',
                'h2',
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Сортировка элементов по свойству
     *
     * @return void
     */
    public function testSortByCombinedReverse(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'order' => [
                    'by' => 'size',
                    'direction' => 'desc',
                    'type' => 'property_keywords'
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h2',
                'h1',
                'h3',
                'p1',
                's2',
                's3',
                's1',
                's4',
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }
    
}