<?php

namespace IQDEV\ElasticSearchTests\FIlter;

use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;
use IQDEV\Search\SearchQuery\SearchQuery;
use PHPUnit\Framework\TestCase;

class SearchItemsTest extends TestCase
{
    /**
     * Поиск всех элементов раздела
     *
     * @return void
     */
    public function testExistByCategory(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'categoryId' => ['prices'],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск всех элементов раздела
     *
     * @return void
     */
    public function testExistByEmptyCategory(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'categoryId' => [''],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Поиск всех элементов
     *
     * @return void
     */
    public function testExistAllItems(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'query' => ''
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's1',
                's2',
                's3',
                's4',
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск существующего элемента по части строки поиска
     *
     * @return void
     */
    public function testExistItemsByPart(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'query' => 'Nike'
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's4',
                'h1',
                'h2',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск существующего элемента по полному названию
     *
     * @return void
     */
    public function testExistItemsByName(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'query' => 'Nike Dri-FIT Strike'
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1',
                'h2',
                's4'
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }

    /**
     * Поиск существующего элемента по полному названию
     *
     * @return void
     */
    public function testExistItemsByCyrillicName(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'query' => 'Товар с ценой'
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'p1',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }
}