<?php

namespace IQDEV\ElasticSearchTests\FIlter;

use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;
use IQDEV\Search\SearchQuery\SearchQuery;
use PHPUnit\Framework\TestCase;

class RangeTest extends TestCase
{
    /**
     * Поиск элементов по мин цене
     *
     * @return void
     */
    public function testExistByMinPrice(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['min' => 103],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's4',
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по мин цене
     *
     * @return void
     */
    public function testExistByMinPrice2(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['min' => 103.01],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по мин цене
     *
     * @return void
     */
    public function testExistByMinPrice3(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['min' => 102.99],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's4',
                'h1',
                'h2',
                'h3',
                'p1'
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по макс цене
     *
     * @return void
     */
    public function testExistByMaxPrice(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['max' => 102],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's1',
                's2',
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по макс цене
     *
     * @return void
     */
    public function testExistByMaxPrice2(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['max' => 102.99],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's1',
                's2',
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по макс цене
     *
     * @return void
     */
    public function testExistByMaxPrice3(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['max' => 101.99],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's1',
                's2',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['min' => 101, 'max' => 102],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's2',
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice2(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['min' => 101.01, 'max' => 102],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's3',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice3(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['min' => 101, 'max' => 101.99],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                's2',
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatData($result));
    }

    /**
     * Поиск элементов по диапазону цен
     *
     * @return void
     */
    public function testExistByRangePrice4(): void
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'price' => ['min' => 101.01, 'max' => 101.99],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
            ]
        ];

        $this->assertEquals($expected, FormatData::formatData($result));
    }
}