<?php

namespace IQDEV\ElasticSearchTests\Helpers;

use IQDEV\Search\Document\Document;
use IQDEV\Search\Facet\Facet;
use IQDEV\Search\Facet\FacetItemList;
use IQDEV\Search\Facet\FacetItemRange;
use IQDEV\Search\SearchQuery\SearchResult;

class FormatData
{
    public static function formatData(SearchResult $oResult): array
    {
        $aResult = ['hits' => []];
        foreach ($oResult->hits as $oHit) {
            /** @var Document $oHit */
            $aResult['hits'][] = $oHit->id;
        }
        return $aResult;
    }

    public static function formatDataWFacets(SearchResult $result): array
    {
        $aResult         = ['facets' => []];
        $aResult['hits'] = static::formatData($result)['hits'];
        $facets          = $result->facets->sort('getPosition');
        foreach ($facets as $facet) {
            /** @var Facet $facet */
            $dataFacet = [
                'code' => $facet->getCode(),
                'label' => $facet->getLabel(),
                'type' => $facet->getType()::getType(),
                'items' => [
                    'list' => [],
                    'range' => []
                ],
            ];

            $items = $facet->items->sort('getValue');
            foreach ($items as $item) {
                if ($item instanceof FacetItemList) {
                    /** @var FacetItemList $item */
                    $dataFacet['items']['list'][] = [
                        'label' => $item->getLabel(),
                        'value' => $item->getValue(),
                        'count' => $item->getCount(),
                        'active' => $item->isActive(),
                    ];
                }
                if ($item instanceof FacetItemRange) {
                    /** @var FacetItemRange $item */

                    $aData = [
                        'label' => $item->getLabel(),
                        'count' => $item->getCount(),
                        'active' => $item->isActive(),
                    ];
                    
                    $aData['fullRange']   = $item->getFullRange();
                    $aData['activeRange'] = $item->getSelectedRange();
                    
                    if ($result->numProduct > 0 && empty(array_filter($aData['activeRange']))) {
                        $aData['activeRange'] = $aData['fullRange']; 
                    }

                    $dataFacet['items']['range'][] = $aData;
                }
            }

            $aResult['facets'][] = $dataFacet;
        }
        return $aResult;
    }
}