<?php

namespace IQDEV\ElasticSearchTests\FIlter;

use IQDEV\ElasticSearchTests\Helpers\FormatData;
use IQDEV\ElasticSearchTests\Service\SearchClient;
use IQDEV\Search\SearchQuery\SearchQuery;
use PHPUnit\Framework\TestCase;

/**
 * Тестирование агрегирующих функций
 */
class AggsTest extends TestCase
{
    public function testEmptyFilterByCategory()
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'categoryId' => 't-short',
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1',
                'h2',
                'h3'
            ],
            'facets' => [
                0 => [
                    'code' => 'brand',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'nike',
                                'count' => 2,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'rebook',
                                'count' => 1,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                1 => [
                    'code' => 'color',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'red',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'white',
                                'count' => 2,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                2 => [
                    'code' => 'size',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'xl',
                                'count' => 2,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'xxl',
                                'count' => 1,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                3 => [
                    'code' => 'price',
                    'label' => null,
                    'type' => 'range',
                    'items' => [
                        'list' => [],
                        'range' => [
                            0 => [
                                'label' => null,
                                'count' => 3,
                                'active' => true,
                                'fullRange' => [
                                    'min' => 104.0,
                                    'max' => 106.0
                                ],
                                'activeRange' => [
                                    'min' => 104.0,
                                    'max' => 106.0
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataWFacets($result));
    }

    public function testEmptyKeywordFilter()
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'categoryId' => 't-short',
                    'color' => ['white'],
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h2',
                'h3'
            ],
            'facets' => [
                0 => [
                    'code' => 'brand',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'nike',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'rebook',
                                'count' => 1,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                1 => [
                    'code' => 'color',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'red',
                                'count' => 0,
                                'active' => false
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'white',
                                'count' => 2,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                2 => [
                    'code' => 'size',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'xl',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'xxl',
                                'count' => 1,
                                'active' => true
                            ]
                        ],
                        'range' => []
                    ]
                ],
                3 => [
                    'code' => 'price',
                    'label' => null,
                    'type' => 'range',
                    'items' => [
                        'list' => [],
                        'range' => [
                            0 => [
                                'label' => null,
                                'count' => 2,
                                'active' => true,
                                'fullRange' => [
                                    'min' => 104.0,
                                    'max' => 106.0
                                ],
                                'activeRange' => [
                                    'min' => 105.0,
                                    'max' => 106.0
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataWFacets($result));
    }

    public function testRangeFilter()
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'categoryId' => 't-short',
                    'price' => ['max' => 104.50]
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1',
            ],
            'facets' => [
                0 => [
                    'code' => 'brand',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'nike',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'rebook',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                1 => [
                    'code' => 'color',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'red',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'white',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                2 => [
                    'code' => 'size',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'xl',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'xxl',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                3 => [
                    'code' => 'price',
                    'label' => null,
                    'type' => 'range',
                    'items' => [
                        'list' => [],
                        'range' => [
                            0 => [
                                'label' => null,
                                'count' => 1,
                                'active' => true,
                                'fullRange' => [
                                    'min' => 104.0,
                                    'max' => 106.0
                                ],
                                'activeRange' => [
                                    'min' => 104.0,
                                    'max' => 104.0
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataWFacets($result));
    }

    public function testCombineFilter()
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'categoryId' => 't-short',
                    'color' => ['black'],
                    'price' => ['max' => 104]
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [],
            'facets' => [
                0 => [
                    'code' => 'brand',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'nike',
                                'count' => 0,
                                'active' => false
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'rebook',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                1 => [
                    'code' => 'color',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'red',
                                'count' => 0,
                                'active' => false
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'white',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                2 => [
                    'code' => 'size',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'xl',
                                'count' => 0,
                                'active' => false
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'xxl',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                3 => [
                    'code' => 'price',
                    'label' => null,
                    'type' => 'range',
                    'items' => [
                        'list' => [],
                        'range' => [
                            0 => [
                                'label' => null,
                                'count' => 0,
                                'active' => false,
                                'fullRange' => [
                                    'min' => 104.0,
                                    'max' => 106.0
                                ],
                                'activeRange' => [
                                    'min' => null,
                                    'max' => null
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataWFacets($result));
    }

    public function testCombineFilterTwo()
    {
        $handler = SearchClient::getInstance();

        $q      = SearchQuery::createFromArray(
            [
                'filters' => [
                    'categoryId' => 't-short',
                    'color' => ['red'],
                    'price' => ['max' => 105]
                ]
            ]
        );
        $result = $handler->handle($q);

        $expected = [
            'hits' => [
                'h1'
            ],
            'facets' => [
                0 => [
                    'code' => 'brand',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'nike',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'rebook',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                1 => [
                    'code' => 'color',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'red',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'white',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                2 => [
                    'code' => 'size',
                    'label' => null,
                    'type' => 'list',
                    'items' => [
                        'list' => [
                            0 => [
                                'label' => null,
                                'value' => 'xl',
                                'count' => 1,
                                'active' => true
                            ],
                            1 => [
                                'label' => null,
                                'value' => 'xxl',
                                'count' => 0,
                                'active' => false
                            ]
                        ],
                        'range' => []
                    ]
                ],
                3 => [
                    'code' => 'price',
                    'label' => null,
                    'type' => 'range',
                    'items' => [
                        'list' => [],
                        'range' => [
                            0 => [
                                'label' => null,
                                'count' => 1,
                                'active' => true,
                                'fullRange' => [
                                    'min' => 104.0,
                                    'max' => 106.0
                                ],
                                'activeRange' => [
                                    'min' => 104.0,
                                    'max' => 104.0
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        $this->assertEqualsCanonicalizing($expected, FormatData::formatDataWFacets($result));
    }
}