<?php

namespace IQDEV\ElasticSearch\Search;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;

class Nested implements Esable
{
    protected ?string $path = null;
    protected ?Query $query = null;

    public function __construct()
    {
    }

    public function setPath(string $p): self
    {
        $this->path = $p;
        return $this;
    }

    public function setQuery(Query $q): self
    {
        $this->query = $q;
        return $this;
    }

    public function es(): array
    {
        $nested = [];

        if ($this->path) {
            $nested['path'] = $this->path;
        }

        if (isset($this->query) && $this->query->isEmpty() === false) {
            $nested['query'] = $this->query->es()['query'];
        }

        return ['nested' => $nested];
    }
}
