<?php

namespace IQDEV\ElasticSearch\Search\Aggs;


use IQDEV\ElasticSearch\Esable;

final class Terms implements Esable
{
    private array $options = [];
    private string $field;

    /**
     * @param string $field
     */
    public function __construct(string $field)
    {
        $this->field = $field;
    }

    public function setSize(int $size): self
    {
        $this->options['size'] = $size;
        return $this;
    }

    public function es(): array
    {
        $data          = $this->options;
        $data['field'] = $this->field;

        return ['terms' => $data];
    }
}