<?php

namespace IQDEV\ElasticSearch\Search\Aggs;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;
use IQDEV\ElasticSearch\Search\Nested;

final class Aggs implements Esable
{
    private ?AggsCollection $aggs = null;
    private ?Query $query = null;
    private ?Nested $nested = null;
    private ?Terms $terms = null;
    private ?ExtremumTerms $extremumTerms = null;
    private string $key;

    public function __construct(string $key)
    {
        $this->key = $key;
    }

    /**
     * @param Aggs|null $aggs
     * @return Aggs
     */
    public function addAggs(?Aggs $aggs): self
    {
        if ($this->aggs === null) {
            $this->aggs = new AggsCollection();
        }

        $this->aggs->add($aggs);
        return $this;
    }

    /**
     * @param Query|null $query
     * @return Aggs
     */
    public function setQuery(?Query $query): self
    {
        $this->query = $query;
        return $this;
    }

    /**
     * @param Nested|null $nested
     * @return Aggs
     */
    public function setNested(?Nested $nested): self
    {
        $this->nested = $nested;
        return $this;
    }

    /**
     * @param Terms|null $terms
     * @return Aggs
     */
    public function setTerms(?Terms $terms): self
    {
        $this->terms = $terms;
        return $this;
    }

    /**
     * @param ExtremumTerms|null $terms
     * @return Aggs
     */
    public function setExtremumTerms(?ExtremumTerms $terms): self
    {
        $this->extremumTerms = $terms;
        return $this;
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }

    public function es(): array
    {
        $agg = [];

        if ($this->aggs) {
            $agg['aggs'] = array_merge($agg, $this->aggs->es()['aggs']);
        }

        if (isset($this->query) && $this->query->isEmpty() === false) {
            $agg['filter'] = $this->query->es()[$this->query->getType()];
        }

        if ($this->nested) {
            $agg['nested'] = $this->nested->es()['nested'];
        }

        if ($this->terms) {
            $agg['terms'] = $this->terms->es()['terms'];
        }
        
        if ($this->extremumTerms) {
            $agg = array_merge($agg, $this->extremumTerms->es());
        }

        return $agg;
    }
}