<?php

namespace IQDEV\ElasticSearch\Document;

use IQDEV\ElasticSearch\Facet\FacetCategory;
use IQDEV\ElasticSearch\Facet\FacetCollection;

class ProductDocument implements Document
{
    private FacetCollection $keywordFacets;
    private FacetCollection $numberFacets;
    private ?string $fullSearchContent = null;

    private FacetCategory $categoryFacet;

    public function __construct(FacetCategory $categoryFacet)
    {
        $this->keywordFacets = new FacetCollection();
        $this->numberFacets = new FacetCollection();
        $this->categoryFacet = $categoryFacet;
    }

    /**
     * @return FacetCollection
     */
    public function getKeywordFacets(): FacetCollection
    {
        return $this->keywordFacets;
    }

    /**
     * @return FacetCategory
     */
    public function getCategoryFacet(): FacetCategory
    {
        return $this->categoryFacet;
    }

    /**
     * @return FacetCollection
     */
    public function getNumberFacets(): FacetCollection
    {
        return $this->numberFacets;
    }

    /**
     * @param string|null $fullSearchContent
     */
    public function setFullSearchContent(?string $fullSearchContent): void
    {
        $this->fullSearchContent = $fullSearchContent;
    }

    public function es(): array
    {
        $document = [
            'category_id' => $this->getCategoryFacet()->es()['category_id'],
            'search_data' => [
                'keyword_facet' => $this->getKeywordFacets()->es(),
                'number_facet' => $this->getNumberFacets()->es()
            ],
        ];

        if ($this->fullSearchContent) {
            $document['full_search_content'] = $this->fullSearchContent;
        }

        return $document;
    }
}
