<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\Nested;
use IQDEV\ElasticSearch\Filter\FilterOperator;

final class FilterNumberFacet implements Esable
{

    public function __construct(
        public string $key,
        public array $conditions
    ) {
    }

    public function es(): array
    {
        $path = 'search_data.number_facet';

        $nested = new Nested();

        $query = new Query();
        $query
            ->filter(new Stats($path.'.facet_code', $this->key));

        $conditions = [];
        foreach ($this->conditions as $operator => $value) {
            $key = in_array(FilterOperator::from($operator), [
                FilterOperator::GTE,
                FilterOperator::LTE,
                FilterOperator::GT,
                FilterOperator::LT,
            ]) ? $operator : null;

            if (isset($key)) {
                $conditions[$key] = $value;
            }
        }
        $query->filter(new Stats($path.'.facet_value', $conditions));

        $nested
            ->setPath($path)
            ->setQuery($query);

        return $nested->es();
    }
}
