<?php

namespace IQDEV\ElasticSearch\Order;

use IQDEV\ElasticSearch\Document\Property\Property;
use IQDEV\ElasticSearch\Esable;

abstract class Order implements Esable
{
    public function __construct(
        protected Property $property,
        protected OrderDirection $direction,
        protected array $additionalParams = [],
    ) {
    }

    public function getProperty(): Property
    {
        return $this->property;
    }

    public function getDirection(): OrderDirection
    {
        return $this->direction;
    }

    public function getAdditionalParams(): array
    {
        return $this->additionalParams;
    }
}
