<?php

namespace IQDEV\ElasticSearch\Filter;

final class Filter
{
    public function __construct(
        private Field          $field,
        private FilterOperator $operator,
        private FilterValue    $value
    ) {
    }

    public function field(): Field
    {
        return $this->field;
    }

    public function operator(): FilterOperator
    {
        return $this->operator;
    }

    public function value(): FilterValue
    {
        return $this->value;
    }
}
