<?php

namespace IQDEV\ElasticSearch\Filter\Collection;

use IQDEV\ElasticSearch\Filter\Filter;
use IQDEV\ElasticSearch\Filter\FilterType;
use IQDEV\ElasticSearch\Filter\LogicOperator;
use Ramsey\Collection\AbstractCollection;

/**
 * @method bool add(Filter $item)
 */
class FilterGroupCollection extends AbstractCollection
{
    /** @var LogicOperator Тип логической операции для коллекции */
    protected LogicOperator $logicOperator;
    /** @var FilterType Тип фильтра для коллекции */
    protected FilterType $filterType;

    /**
     * @param Filter[] $data
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->logicOperator = LogicOperator::AND;
        $this->filterType = FilterType::post();
    }

    /**
     * @inheritDoc
     */
    public function getType(): string
    {
        return Filter::class;
    }

    /**
     * Установка типа логической операции
     *
     * @param LogicOperator $type
     *
     * @return $this
     */
    public function setLogicOperator(LogicOperator $type): self
    {
        $this->logicOperator = $type;

        return $this;
    }

    /**
     * Получение типа логической операции
     *
     * @return LogicOperator
     */
    public function getLogicOperator(): LogicOperator
    {
        return $this->logicOperator;
    }

    /**
     * Установка типа фильтрации
     *
     * @param FilterType $type
     *
     * @return $this
     */
    public function setFilterType(FilterType $type): self
    {
        $this->filterType = $type;

        return $this;
    }

    /**
     * Получение типа фильтрации
     *
     * @return FilterType
     */
    public function getFilterType(): FilterType
    {
        return $this->filterType;
    }
}
