<?php

namespace IQDEV\ElasticSearch;

use IQDEV\ElasticSearch\Filter\Collection\FilterCollection;
use IQDEV\ElasticSearch\Order\OrderCollection;

final class Criteria
{
    private FilterCollection $filters;
    private OrderCollection $sorting;
    private Pagination $pagination;

    public function __construct()
    {
        $this->filters = new FilterCollection();
        $this->sorting = new OrderCollection();
        $this->pagination = new Pagination();
    }

    public function filters(): FilterCollection
    {
        return $this->filters;
    }

    public function sorting(): OrderCollection
    {
        return $this->sorting;
    }

    public function pagination(): Pagination
    {
        return $this->pagination;
    }
}
