<?php

namespace IQDEV\ElasticSearch\Facet;

final class FacetKeyword implements Facet
{
    private string $key;
    /** @var string|string[] */
    private $value;

    /**
     * @param string|string[] $value
     */
    public function __construct(string $key, $value)
    {
        $this->key = $key;
        $this->value = $value;
    }

    public function es(): array
    {
        return [
            'facet_code' => $this->key,
            'facet_value' => $this->value,
        ];
    }
}
