<?php

namespace IQDEV\ElasticSearch\Request\Order;

use IQDEV\ElasticSearch\Document\Property\Property;
use IQDEV\ElasticSearch\Document\Property\PropertyType;
use IQDEV\ElasticSearch\Request\Order\Type\BaseOrder;
use IQDEV\ElasticSearch\Request\Order\Type\KeywordPropertyOrder;
use IQDEV\ElasticSearch\Request\Order\Type\NumberPropertyOrder;

class OrderFactory
{
    public static function createByProperty(
        Property $property,
        OrderDirection $direction,
    ): Order {
        return match ($property->getType()) {
            PropertyType::KEYWORD => new KeywordPropertyOrder($property, $direction),
            PropertyType::NUMBER => new NumberPropertyOrder($property, $direction),
            default => new BaseOrder($property, $direction),
        };
    }
}
