<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Request\Match;

use IQDEV\ElasticSearch\Esable;
use Ramsey\Collection\AbstractCollection;

class QueryMatchCollection extends AbstractCollection implements Esable
{

    /**
     * @inheritDoc
     */
    public function getType(): string
    {
        return QueryMatch::class;
    }

    public function es(): array
    {
        $matches = [];
        foreach ($this->toArray() as $match) {
            /** @var QueryMatch $match */
            $matches = array_merge($match->es());
        }

        return $matches;
    }
}
