<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Request\Match;

use IQDEV\ElasticSearch\Esable;

class QueryMatch implements Esable
{
    public function __construct(
        private readonly string $key,
        private readonly string $value,
    ) {
    }

    public function es(): array
    {
        return [
            $this->key => [
                'query' => $this->value
            ]
        ];
    }
}
