<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Filter;

use IQDEV\ElasticSearch\Converter\Request\Filter\Type\KeywordFilterType;
use IQDEV\ElasticSearch\Converter\Request\Filter\Type\RangeFilterType;
use IQDEV\ElasticSearch\Request\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Request\Filter\Filter;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;

class PropertyFilter extends AbstractFilterQuery
{
    public function getQuery(FilterGroupCollection $filterGroupCollection): Query
    {
        $keywordFiltersGroup = $filterGroupCollection->getKeywordFilters();
        foreach ($keywordFiltersGroup as $keywordFilter) {
            /** @var Filter $keywordFilter */
            $esableFilter = new KeywordFilterType($keywordFilter);

            $this->setFilterByLogic($filterGroupCollection->getLogicOperator(), $esableFilter->getEsable());
        }

        $rangeFilterGroup = $filterGroupCollection->getRangeFilters();
        $rangesFilter = RangeFilterType::getFiltersByOneProperty($rangeFilterGroup);
        foreach ($rangesFilter as $filterGroup) {
            /** @var FilterGroupCollection $filterGroup */

            $esableFilter = new RangeFilterType($filterGroup);
            $this->setFilterByLogic($filterGroupCollection->getLogicOperator(), $esableFilter->getEsable());
        }

        return $this->query;
    }
}
