<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Filter;

use IQDEV\ElasticSearch\Converter\Request\Filter\Type\KeywordFilterType;
use IQDEV\ElasticSearch\Converter\Request\Filter\Type\RangeFilterType;
use IQDEV\ElasticSearch\Request\Filter\Collection\FilterGroupCollection;
use IQDEV\ElasticSearch\Request\Filter\Filter;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;
use IQDEV\ElasticSearch\Search\BoolQuery\Terms;
use IQDEV\ElasticSearch\Search\Nested;

class NestedFilter extends AbstractFilterQuery
{
    public const NESTED_RANGE_PATH = 'search_data.number_facet';
    public const NESTED_KEYWORD_PATH = 'search_data.keyword_facet';

    public function getQuery(FilterGroupCollection $filterGroupCollection): Nested
    {
        $keywordFiltersGroup = $filterGroupCollection->getKeywordFilters();
        foreach ($keywordFiltersGroup as $keywordFilter) {
            /** @var Filter $keywordFilter */
            $esableFilter = new KeywordFilterType($keywordFilter);

            $this->setFilterByLogic($filterGroupCollection->getLogicOperator(), $this->getNested($esableFilter, self::NESTED_KEYWORD_PATH));
        }

        $rangeFilterGroup = $filterGroupCollection->getRangeFilters();
        $rangesFilter = RangeFilterType::getFiltersByOneProperty($rangeFilterGroup);
        foreach ($rangesFilter as $filterGroup) {
            /** @var FilterGroupCollection $filterGroup */

            $esableFilter = new RangeFilterType($filterGroup);
            $this->setFilterByLogic($filterGroupCollection->getLogicOperator(), $this->getNested($esableFilter, self::NESTED_RANGE_PATH));
        }

        return (new Nested())
            ->setPath('search_data')
            ->setQuery($this->query);
    }

    private function getNested(RangeFilterType|KeywordFilterType $filter, string $path): Nested
    {
        $cloneFilter = clone $filter;
        $nested = new Nested();
        $query = new Query();

        $query->getFilter()->add(new Terms($path . '.facet_code', $cloneFilter->getField()));

        $cloneFilter->setField($path . '.facet_value');
        $query->getFilter()->add($cloneFilter->getEsable());

        $nested
            ->setPath($path)
            ->setQuery($query);

        return $nested;
    }
}
