<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Aggregation;

use IQDEV\ElasticSearch\Configuration;
use IQDEV\ElasticSearch\Converter\Request\FilterQuery;
use IQDEV\ElasticSearch\Request\Filter\Collection\FilterCollection;
use IQDEV\ElasticSearch\Request\Filter\Filter;
use IQDEV\ElasticSearch\Request\Filter\Value\FilterKeyword;
use IQDEV\ElasticSearch\Search\Aggs\Aggs;
use IQDEV\ElasticSearch\Search\Aggs\AggsFacetTerms;
use IQDEV\ElasticSearch\Search\BoolQuery\Query;
use IQDEV\ElasticSearch\Search\Nested;

class FilterAggregation
{
    private ?Aggs $aggregation = null;

    public function __construct(
        private readonly Configuration $configuration,
        private readonly Filter $filter,
        private readonly FilterCollection $filterCollection,
    ) {
        if ($filter->value() instanceof FilterKeyword) {
            $this->setAggregation();
        }
    }

    private function setAggregation(): void
    {
        $this->aggregation = new Aggs(
            $this->getKey('keyword', $this->filter->field()->value())
        );

        $this->aggregation->addAggs(
            AggsFacetTerms::create(
                'agg_special',
                'keyword_facet'
            )
        );

//        $queryKeywordFiltered = new Query();
//
//        $keywordFilterCollection = $this->filterCollection->getKeywordFilters([$this->filter->field()->value()]);
//        $rangeFilterCollection = $this->filterCollection->getNumberFilters();
//
//        $keywordFilterQuery = (new FilterQuery($this->configuration, $keywordFilterCollection))->getQuery();
//        $rangeFilterQuery = (new FilterQuery($this->configuration, $rangeFilterCollection))->getQuery();
//
//        if (false === $keywordFilterQuery->isEmpty()) {
//            foreach ($keywordFilterQuery->getFilter() as $filter) {
//                $queryKeywordFiltered->getFilter()->add($filter);
//            }
//        }
//
//        if (false === $rangeFilterQuery->isEmpty()) {
//            foreach ($rangeFilterQuery->getFilter() as $filter) {
//                $queryKeywordFiltered->getFilter()->add($filter);
//            }
//        }
//
//        if ($queryKeywordFiltered->isEmpty() === false) {
//            $this->aggregation->setQuery($queryKeywordFiltered);
//        } else {
//            $this->aggregation->setNested((new Nested())->setPath('search_data'));
//        }
    }

    public function getFilterAggregation(): ?Aggs
    {
        return $this->aggregation;
    }

    private function getKey(string $type, string $name): string
    {
        return sprintf('%s_facet_%s', $type, $name);
    }
}
