<?php

namespace IQDEV\ElasticSearch\Criteria\Order;

use IQDEV\ElasticSearch\Document\Property\Property;
use IQDEV\ElasticSearch\Document\Property\PropertyType;
use IQDEV\ElasticSearch\Criteria\Order\Type\BaseOrder;
use IQDEV\ElasticSearch\Criteria\Order\Type\KeywordPropertyOrder;
use IQDEV\ElasticSearch\Criteria\Order\Type\NumberPropertyOrder;

class OrderFactory
{
    public static function createByProperty(
        Property $property,
        OrderDirection $direction,
    ): Order {
        return match ($property->getType()) {
            PropertyType::KEYWORD => new KeywordPropertyOrder($property, $direction),
            PropertyType::NUMBER => new NumberPropertyOrder($property, $direction),
            default => new BaseOrder($property, $direction),
        };
    }
}
