<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Converter\Request\Filter\Type;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Criteria\Filter\Filter;
use IQDEV\ElasticSearch\Search\BoolQuery\Terms;

class KeywordFilterType extends AbstractFilterType
{
    public function __construct(
        private readonly Filter $filter,
    ) {
        $this->field = $this->filter->field()->value();
    }

    public function getEsable(): Esable
    {
        return new Terms($this->field, $this->filter->value()->value());
    }
}
