<?php

declare(strict_types=1);

namespace IQDEV\ElasticSearch\Criteria\Match;

use IQDEV\ElasticSearch\Esable;

class QueryMatch implements Esable
{
    public function __construct(
        private readonly string $key,
        private readonly mixed $value,
    ) {
    }

    public function es(): array
    {
        return [
            $this->key => [
                'query' => $this->value
            ]
        ];
    }
}
