<?php

namespace IQDEV\ElasticSearch\Criteria\Order\Type;

use IQDEV\ElasticSearch\Criteria\Order\Order;

class NumberPropertyOrder extends Order
{
    public function es(): array
    {
        $order = [
            'order' => $this->direction->value,
            'nested' => [
                'path' => 'search_data',
                'filter' => [
                    'bool' => [
                        'must' => [
                            'term' => [
                                'search_data.number_facet.facet_code' => $this->property->getKey(),
                            ],
                        ],
                    ],
                ],
            ],
        ];

        return [
            'search_data.number_facet.facet_value' => array_merge(
                $order,
                $this->additionalParams
            ),
        ];
    }
}
