<?php

namespace IQDEV\ElasticSearch\Order;

class OrderNumberProperty extends Order
{
    public function es(): array
    {
        $order = [
            'order' => $this->direction::getType(),
            'nested' => [
                'path' => 'search_data',
                'filter' => [
                    'bool' => [
                        'must' => [
                            'term' => [
                                'search_data.number_facet.facet_code' => $this->by,
                            ]
                        ],
                    ],
                ],
            ],
        ];
        $order = array_merge($order, $this->properties);
        return [
            'search_data.number_facet.facet_value' => $order,
        ];
    }
}
