<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;
use IQDEV\ElasticSearch\Search\Nested;

final class FilterKeywordFacet implements Esable
{
    public string $key;

    /** @var string|string[] */
    public $value;

    public function __construct(string $key, $value)
    {
        $this->key = $key;
        $this->value = $value;
    }

    public function es(): array
    {
        $path = 'search_data.keyword_facet';

        $nested = new Nested();

        $query = new Query();
        $query
            ->filter(new Terms($path . '.facet_code', $this->key))
            ->filter(new Terms($path . '.facet_value', $this->value));

        $nested
            ->setPath($path)
            ->setQuery($query);

        return $nested->es();
    }
}
