<?php

namespace IQDEV\ElasticSearch\Search\BoolQuery;

use IQDEV\ElasticSearch\Esable;

final class Stats implements Esable
{
    private string $key;
    /**
     * @var string|float|string[]|float[]
     */
    private $value;

    /**
     * @param string|float|string[]|float[] $value
     */
    public function __construct(string $key, $value)
    {
        $this->key = $key;
        $this->value = $value;
    }

    public function es(): array
    {
        $keyStats = is_array($this->value) ? 'range' : 'term';

        return [
            $keyStats => [
                $this->key => $this->value,
            ],
        ];
    }
}
