<?php

return [
    'properties' => [
        'data' => [
            'type' => 'object',
            'enabled' => false,
        ],
        'full_search_content' => [
            'type' => 'text',
        ],
        'suggest_search_content' => [
            'type' => 'text',
            'analyzer' => 'autocomplete',
            'search_analyzer' => 'standard',
        ],
        'category_id' => [
            'type' => 'keyword',
            'index' => false,
        ],
        'rating' => [
            'type' => 'double',
            'index' => false,
        ],
        'popular' => [
            'type' => 'double',
            'index' => false,
        ],
        'search_data' => [
            'type' => 'nested',
            'properties' => [
                'keyword_facet' => [
                    'type' => 'nested',
                    'properties' => [
                        'facet_code' => [
                            'type' => 'keyword',
                            'index' => true
                        ],
                        'facet_value' => [
                            'type' => 'keyword',
                            'index' => true
                        ]
                    ]
                ],
                'number_facet' => [
                    'type' => 'nested',
                    'properties' => [
                        'facet_code' => [
                            'type' => 'keyword',
                            'index' => true
                        ],
                        'facet_value' => [
                            'type' => 'double'
                        ]
                    ]
                ]
            ]
        ]
    ],
];
