<?php

declare(strict_types=1);

namespace IQDEV\Tests\Packages\DoctrineHttpFilter\Fixture;

use Doctrine\Persistence\ObjectManager;
use IQDEV\Tests\Packages\DoctrineHttpFilter\Entity\Post;

class PostFixture extends BaseFixture
{
    public function load(ObjectManager $manager): void
    {
        for ($i = 0; $i < $this->count; ++$i) {
            $post = new Post(
                $this->faker->name(),
                $this->faker->text(),
                $this->faker->boolean(),
                \DateTimeImmutable::createFromInterface($this->faker->dateTime()),
            );

            $manager->persist($post);
        }

        $manager->flush();
    }
}
