<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter;

use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\HttpFoundation\Request;

/**
 * @method getEntityManager()
 * @method getClassName()
 */
trait HttpFilterTrait
{
    public HttpFilterEntityRepository $repository;

    final public function createQueryByFilter(iterable $filters, ?Request $request = null): QueryBuilder
    {
        if (! isset($this->repository)) {
            $this->repository = new HttpFilterEntityRepository(
                $this->getEntityManager(),
                new ClassMetadata($this->getClassName())
            );
        }

        return $this->repository->createQueryByFilter($filters, $this->getAliasTableForFilter(), $request);
    }

    abstract public function getAliasTableForFilter(): string;
}
