<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class Where extends HttpFilter
{
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        if ($this->getHttpValue() === null) {
            return $queryBuilder;
        }

        $queryBuilder->where(
            $this->getColumn() . ' = :' . $this->getParameterKey(),
        );

        $queryBuilder->setParameter($this->getParameterKey(), $this->getHttpValue());

        return $queryBuilder;
    }
}
