<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class Range extends HttpFilter
{
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        if ((! isset($this->getHttpValue()['min']) || ! is_numeric($this->getHttpValue()['min']))
                && (! isset($this->getHttpValue()['max']) || ! is_numeric($this->getHttpValue()['max']))) {
            return $queryBuilder;
        }

        if (isset($this->getHttpValue()['min'])) {
            $queryBuilder->where(
                $this->getColumn() . ' >= ' . $this->getHttpValue()['min'],
            );
        }

        if (isset($this->getHttpValue()['max'])) {
            $queryBuilder->andWhere(
                $this->getColumn() . ' <= ' . $this->getHttpValue()['max'],
            );
        }

        return $queryBuilder;
    }
}
