<?php

declare(strict_types=1);

namespace IQDEV\Tests\Packages\DoctrineHttpFilter\Fixture;

use Doctrine\Persistence\ObjectManager;
use IQDEV\Tests\Packages\DoctrineHttpFilter\Entity\Comment;
use IQDEV\Tests\Packages\DoctrineHttpFilter\Entity\Post;
use IQDEV\Tests\Packages\DoctrineHttpFilter\Repository\PostRepository;

class CommentFixture extends BaseFixture
{
    public function load(ObjectManager $manager): void
    {
        /** @var PostRepository $postRepository */
        $postRepository = $manager->getRepository(Post::class);

        /** @var array<Post> $posts */
        $posts = $postRepository->findAll();

        for ($i = 0; $i < $this->count; $i++) {
            $comment = new Comment(
                $this->faker->userName(),
                $this->faker->text(),
                \DateTimeImmutable::createFromInterface($this->faker->dateTime()),
                $this->faker->randomElement($posts),
            );

            $manager->persist($comment);
        }

        $manager->flush();
    }

    public function getDependencies(): array
    {
        return [
            PostFixture::class,
        ];
    }
}
