<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter;

use Doctrine\ORM\QueryBuilder;
use Symfony\Component\HttpFoundation\Request;

class HttpSort
{
    public const string REQUEST_SORT_KEY = 'sort';

    public const array SORT_DIRECTIONS  = ['DESC', 'ASC'];

    protected Request $request;

    public function __construct(
        protected string $tableAlias,
        protected string $field,
        ?Request $request = null,
    ) {
        $this->request = $request ?? Request::createFromGlobals();
    }

    protected function getColumn(): string
    {
        return $this->tableAlias . '.' . $this->field;
    }

    protected function getHttpValue(): mixed
    {
        $filter = $this
            ->request
            ->query
            ->getIterator()[static::REQUEST_SORT_KEY] ?? null;

        if ($filter === null) {
            return null;
        }

        return $filter[$this->field] ?? null;
    }

    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        $orderColumns = str_contains($this->field, '.') ? $this->field : $this->getColumn();
        if (in_array($this->getHttpValue(), self::SORT_DIRECTIONS, true)) {
            $queryBuilder->orderBy($orderColumns, $this->getHttpValue());
        }

        return $queryBuilder;
    }
}
