<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter;

use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\HttpFoundation\Request;

/**
 * @method getEntityManager()
 * @method getClassName()
 */
trait HttpFilterTrait
{
    public HttpFilterEntityRepository $repository;

    final public function createQueryByFilter(iterable $filters, ?Request $request = null): QueryBuilder
    {
        if (! isset($this->repository)) {
            $this->repository = new HttpFilterEntityRepository(
                $this->getEntityManager(),
                new ClassMetadata($this->getClassName())
            );
        }

        return $this->repository->createQueryByFilter($filters, $this->getAliasTableForFilter(), $request);
    }

    final public function createQueryForSort(Request $request, ?QueryBuilder $queryBuilder = null): QueryBuilder
    {
        if (! isset($this->repository)) {
            $this->repository = new HttpFilterEntityRepository(
                $this->getEntityManager(),
                new ClassMetadata($this->getClassName())
            );
        }
        $field = array_key_first($request->query->getIterator()[HttpSort::REQUEST_SORT_KEY]);

        return $this->repository->createQueryForSort($field, $this->getAliasTableForFilter(), $request, $queryBuilder);
    }

    abstract public function getAliasTableForFilter(): string;
}
