<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\HttpFoundation\Request;

class HttpFilterEntityRepository extends EntityRepository implements QueryFilterInterface
{
    /** @inheritDoc */
    public function createQueryByFilter(iterable $filters, string $tableAlias, ?Request $request = null): QueryBuilder
    {
        $queryBuilder = $this->createQueryBuilder($tableAlias);

        /**
         * @var string $field
         * @var string|HttpFilter $filter
         */
        foreach ($filters as $field => $filter) {
            if (! $filter instanceof HttpFilter && is_string($filter)) {
                $filter = new $filter($tableAlias, $field, $request);
            }

            $filter->addToQuery($queryBuilder);
        }

        return $queryBuilder;
    }

    public function createQueryForSort(
        string $field,
        string $tableAlias,
        Request $request,
        ?QueryBuilder $queryBuilder = null
    ): QueryBuilder {
        if ($queryBuilder === null) {
            $queryBuilder = $this->createQueryBuilder($tableAlias);
        }

        $sort = new HttpSort($tableAlias, $field, $request);
        $sort->addToQuery($queryBuilder);

        return $queryBuilder;
    }
}
