<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class In extends HttpFilter
{
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        if ($this->getHttpValue() === null || ! is_array($this->getHttpValue())) {
            return $queryBuilder;
        }

        $values = array_map(fn($value) => '\'' . $value . '\'', $this->getHttpValue());
        $stringValues = implode(',', $values);

        $queryBuilder->andWhere(
            $this->getColumn() . ' IN (' . $stringValues . ')',
        );

        return $queryBuilder;
    }
}
