<?php

declare(strict_types=1);

namespace IQDEV\Packages\DoctrineHttpFilter\Filter;

use Doctrine\ORM\QueryBuilder;
use IQDEV\Packages\DoctrineHttpFilter\HttpFilter;

final class Date extends HttpFilter
{
    public function addToQuery(QueryBuilder $queryBuilder): QueryBuilder
    {
        if (is_null($this->getHttpValue())) {
            return $queryBuilder;
        }

        if (! \DateTimeImmutable::createFromFormat('Y-m-d', $this->getHttpValue())) {
            return $queryBuilder;
        }

        $queryBuilder->andWhere(
            $this->getColumn() . ' BETWEEN :dateStart AND :dateEnd',
        );

        $queryBuilder->setParameter('dateStart', $this->getHttpValue() . ' 00:00:00');
        $queryBuilder->setParameter('dateEnd', $this->getHttpValue() . ' 23:59:59');

        return $queryBuilder;
    }
}
